/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.util;

import cursedflames.bountifulbaubles.util.INBTSavable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class Util {
    public static double getAABBVolume(AxisAlignedBB AABB) {
        return (AABB.field_72336_d - AABB.field_72340_a) * (AABB.field_72337_e - AABB.field_72338_b) * (AABB.field_72334_f - AABB.field_72339_c);
    }

    public static NBTTagCompound blockPosToNBT(BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    public static BlockPos blockPosFromNBT(NBTTagCompound tag) {
        if (!(tag.func_74764_b("x") && tag.func_74764_b("y") && tag.func_74764_b("z"))) {
            return null;
        }
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static NBTTagList listToNBTList(List<?> list) {
        NBTTagList taglist = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            taglist.func_74742_a(Util.objectToNBTBase(element));
        }
        return taglist;
    }

    public static List<Object> listFromNBTList(NBTTagList nbtList) {
        return Util.listFromNBTList(nbtList, null);
    }

    public static List<Object> listFromNBTList(NBTTagList nbtList, Class<? extends INBTSavable> type) {
        if (nbtList == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTBase element = nbtList.func_179238_g(i);
            list.add(Util.objectFromNBTBase(element, type));
        }
        return list;
    }

    public static NBTBase objectToNBTBase(Object o) {
        if (o instanceof String) {
            return new NBTTagString((String)o);
        }
        if (o instanceof INBTSavable) {
            return ((INBTSavable)o).writeToNBT();
        }
        throw new IllegalArgumentException(o.getClass().getName() + " can not be stored in a taglist");
    }

    public static Object objectFromNBTBase(NBTBase nbt, Class<? extends INBTSavable> type) {
        if (nbt instanceof NBTTagString) {
            return ((NBTTagString)nbt).func_150285_a_();
        }
        if (nbt instanceof NBTTagCompound && type != null) {
            try {
                return type.newInstance().readFromNBT((NBTTagCompound)nbt);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public static void clearContainer(EntityPlayer playerIn, World worldIn, IItemHandler inventoryIn) {
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            for (int j = 0; j < inventoryIn.getSlots(); ++j) {
                playerIn.func_71019_a(inventoryIn.getStackInSlot(j), false);
            }
        } else {
            for (int i = 0; i < inventoryIn.getSlots(); ++i) {
                playerIn.field_71071_by.func_191975_a(worldIn, inventoryIn.getStackInSlot(i));
            }
        }
    }

    public static void updateBlock(World world, BlockPos pos, IBlockState newState, boolean blockUpdate, boolean sendToClients, boolean noRerender, boolean forceRerenderOnMainThread, boolean preventObserverUpdate) {
        IBlockState oldState = world.func_180495_p(pos);
        int flags = (blockUpdate ? 1 : 0) & (sendToClients ? 2 : 0) & (noRerender ? 4 : 0) & (forceRerenderOnMainThread ? 8 : 0) & (preventObserverUpdate ? 16 : 0);
        world.func_184138_a(pos, oldState, newState != null ? newState : oldState, flags);
    }
}

